﻿using System;
using System.Collections.Generic;
using System.Text;

namespace IndianHealthService.BMXNet.Net
{
    /// <summary>
    /// The crypto used to implement the socket-based BMXNET Broker.  Any crypto can be used if a new
    /// .NET EncryptionProvider is written and a corresponding modification to the RPMS-side is done.
    /// </summary>
    /// <remarks>
    /// An quick experiment can be done by implementing the following ClearText EncryptionProvider and
    /// modifying the RPMS-side encryption routines to do nothing.
    /// <code>
    /// public class ClearText : EncryptionProvider
    /// {
    ///     public string Encrypt(string aString)
    ///     {
    ///         return aString;
    ///     }
    /// 
    ///     public string Decrypt(string aString)
    ///     {
    ///         return aString;
    ///     }
    /// }
    /// </code>
    /// </remarks>
    public interface EncryptionProvider
    {
        /// <summary>
        /// Encrypt aString
        /// </summary>
        /// <param name="aString">The string to be encrypted</param>
        /// <returns>An ASCII encrypted string</returns>
        String Encrypt(String aString);

        /// <summary>
        /// Decrypt aString
        /// </summary>
        /// <param name="aString">The ASCII string to be decrypted</param>
        /// <returns>An ASCII decrypted string</returns>
        String Decrypt(String aString);
    }


}
